<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
                xmlns:rsm="urn:un:unece:uncefact:data:standard:CBFBUY:5"
                >
<xsl:output method="html" 
            encoding="UTF-8" 
            omit-xml-declaration="yes" 
            doctype-public="-//W3C//DTD HTML 4.01//EN"
            media-type="text/html"
            indent="no"/>
<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:template match="/">
	<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<style>
				body{
					font-family: Verdana; 
					display:block;
				}
				tabel{
					display:block;
					border: 1px solid #040;
					border-collapse: collapse;
				}
				th{
					text-align:left;
					border: 1px solid #040;
					border-collapse: collapse;
				}
				td{
					text-align:left;
					border: 1px solid #040;
					border-collapse: collapse;
				}
				td.numeric{
					text-align:right;
				}
				
				div.pdf_thumbs{
					float: left; 
					width: 50%;
				}

				div.pdf_thumbs img{
					width: 100%;
				}

				div.xml_preview{
					float: right,top;
					margin-top: 0;
					margin-left: 50%;
				}
			</style>
			<title>
			</title>
		</head>
		<body>
			<div class="pdf_thumbs">
				<xsl:apply-templates select="document(string($images_xml))/images/image" mode="pdf_thumbs"/>
			</div>
			<div class="xml_preview">
				<div class="seller_trade_party">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction/ApplicableSupplyChainTradeAgreement/SellerTradeParty"/>
				</div>
				<div class="buyer_trade_party">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction/ApplicableSupplyChainTradeAgreement/BuyerTradeParty"/>
				</div>
				<div class="invoice_header">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="invoice_header"/>
				</div>
				<div class="invoice_data">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="invoice_data"/>
				</div>
				<div class="payment_terms">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="payment_terms"/>
				</div>
				<div class="payment_info">
					<xsl:apply-templates select="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="payment_info"/>
				</div>
			</div>
		</body>
	</html>
</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:template match="rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction/ApplicableSupplyChainTradeAgreement/SellerTradeParty">
	<table>
		<tr>
			<th>Rechnungsersteller</th>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="Name"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/LineOne"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/PostcodeCode"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="PostalTradeAddress/CityName"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/CountryID"/>
			</td>
		</tr>
	</table>
</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:template match="rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction/ApplicableSupplyChainTradeAgreement/BuyerTradeParty">
	<table>
		<tr>
			<th>Rechnungsempfänger</th>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="Name"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="DefinedTradeContact/PersonName"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/LineOne"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/PostcodeCode"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="PostalTradeAddress/CityName"/>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:value-of select="PostalTradeAddress/CountryID"/>
			</td>
		</tr>
	</table>
</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

<xsl:template match="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="invoice_header">
	<table>
		<tr>
			<th colspan="2">Rechnung</th>
		</tr>
		<tr>
			<td>Rechnungsnummer</td><td><xsl:value-of select="/rsm:Invoice/rsm:HeaderExchangedDocument/ID"/></td>
		</tr>
		<tr>
			<td>Rechnungsdatum</td><td><xsl:value-of select="/rsm:Invoice/rsm:HeaderExchangedDocument/IssueDateTime"/></td>
		</tr>
		<tr>
			<td>Leistungsdatum</td><td><xsl:value-of select="ApplicableSupplyChainTradeDelivery/ActualDeliverySupplyChainEvent/OccurrenceDateTime"/></td>
		</tr>
		<tr>
			<td>Referenz (bitte bei Zahlung angeben)</td><td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/PaymentReference"/></td>
		</tr>
		<tr>
			<td>Kundennummer</td><td><xsl:value-of select="ApplicableSupplyChainTradeAgreement/BuyerTradeParty/ID"/></td>
		</tr>
		<tr>
			<td>Beträge in</td><td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/InvoiceCurrencyCode"/></td>
		</tr>
		<tr>
			<td>Hinweis</td><td><xsl:value-of select="/rsm:Invoice/rsm:HeaderExchangedDocument/IncludedNote/Content"/></td>
		</tr>
	</table>
</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

<xsl:template match="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="invoice_data">
	<table>
		<tr>
			<th>Pos</th><th>Art.Nr</th><th>Artikelbeschreibung</th><th>Menge</th><th>Einheit</th><th>Einheitspreis</th><th>Betrag</th><th>USt.%</th>
		</tr>
		<xsl:for-each select="IncludedSupplyChainTradeLineItem">
			<tr>
				<td class="numeric"><xsl:number/></td>
				<td><xsl:value-of select="SpecifiedTradeProduct/SellerAssignedID"/></td>
				<td><xsl:value-of select="SpecifiedTradeProduct/Name"/><br/><xsl:text>GTIN: </xsl:text><xsl:value-of select="SpecifiedTradeProduct/GlobalID"/></td>
				<td class="numeric"><xsl:value-of select="SpecifiedSupplyChainTradeDelivery/BilledQuantity"/></td>
				<td>Stk.</td>
				<td class="numeric"><xsl:value-of select="SpecifiedSupplyChainTradeAgreement/NetPriceProductTradePrice/ChargeAmount"/></td>
				<td class="numeric"><xsl:value-of select="SpecifiedSupplyChainTradeSettlement/SpecifiedTradeSettlementMonetarySummation/LineTotalAmount"/></td>
				<td class="numeric"><xsl:value-of select="SpecifiedSupplyChainTradeSettlement/ApplicableTradeTax/ApplicablePercent"/></td>
			</tr>
		</xsl:for-each>

		<tr>
			<td></td>
			<td colspan="5">Rechnungssumme Netto (excl. USt.)</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementMonetarySummation/TaxBasisTotalAmount"/></td>
			<td></td>
		</tr>
		
		<xsl:for-each select="ApplicableSupplyChainTradeSettlement/ApplicableTradeTax">
			<tr>
				<td></td>
				<td colspan="4">Steuerbasisbetrag USt. <xsl:value-of select="ApplicablePercent"/>%</td>
				<td class="numeric"><xsl:value-of select="BasisAmount"/></td>
				<td class="numeric"><xsl:value-of select="CalculatedAmount"/></td>
				<td></td>
			</tr>
		</xsl:for-each>

		<tr>
			<td></td>
			<td colspan="5">Rechnungssumme Brutto (inkl. USt.)</td>
			<td class="numeric"><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementMonetarySummation/GrandTotalAmount"/></td>
			<td></td>
		</tr>
	</table>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

<xsl:template match="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="payment_terms">
	<table>
		<tr>
			<th colspan="2">Zahlungsbedingungen</th>
		</tr>
		<tr>
			<td>Zahlungsziel</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradePaymentTerms/DueDateDateTime"/></td>
		</tr>
		<tr>
			<td>Zahlungsziel (Skonto <xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradePaymentTerms/ApplicableTradePaymentDiscountTerms/CalculationPercent"/>%)</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradePaymentTerms/ApplicableTradePaymentDiscountTerms/BasisDateTime + ApplicableSupplyChainTradeSettlement/SpecifiedTradePaymentTerms/ApplicableTradePaymentDiscountTerms/BasisPeriodMeasure"/></td>
		</tr>
		<tr>
			<td>Zahlungsinformationen</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradePaymentTerms/Description"/></td>
		</tr>
	</table>

</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

<xsl:template match="/images/image" mode="pdf_thumbs">
	<img>
		<xsl:attribute name="src"><xsl:value-of select="."/></xsl:attribute>
	</img>
</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

<xsl:template match="/rsm:Invoice/rsm:SpecifiedSupplyChainTradeTransaction" mode="payment_info">
	<table>
		<tr><th colspan="2">Bank- und Steuerinformatinen</th></tr>
		<tr>
			<td>Kontonr.</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementPaymentMeans/PayeePartyCreditorFinancialAccount/ProprietaryID"/></td>
		</tr>
		<tr>
			<td>IBAN-Nr.</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementPaymentMeans/PayeePartyCreditorFinancialAccount/IBANID"/></td>
		</tr>
		<tr>
			<td>BLZ</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementPaymentMeans/PayeeSpecifiedCreditorFinancialInstitution/GermanBankleitzahlID"/></td>
		</tr>
		<tr>
			<td>BIC</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementPaymentMeans/PayeeSpecifiedCreditorFinancialInstitution/BICID"/></td>
		</tr>
		<tr>
			<td>Bankname</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeSettlement/SpecifiedTradeSettlementPaymentMeans/PayeeSpecifiedCreditorFinancialInstitution/Name"/></td>
		</tr>
		<tr>
			<td>USt.-Identnr.</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeAgreement/SellerTradeParty/SpecifiedTaxRegistration/ID[@schemeID='VA']"/></td>
		</tr>
		<tr>
			<td>Steuernr.</td>
			<td><xsl:value-of select="ApplicableSupplyChainTradeAgreement/SellerTradeParty/SpecifiedTaxRegistration/ID[@schemeID='FC']"/></td>
		</tr>
	</table>

</xsl:template>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++ -->

</xsl:stylesheet>
